package com.jonohennessy {
	import flash.display.*;
	import flash.events.*;
	import com.adamsearle.utils.*;
	
	public class ElementBrowser extends Sprite {
		private var xml:XML;
		private var elementIconArray:Array; // holds an array of the icons
		public var popup:ElementPopup;
		public var homeButton:SimpleButton;
		public var elementContainer:Sprite; // a sprite for all icons to be drawn into
		public var maskSprite:Sprite;
		public var scrollBar:ScrollBar;
		public var parentClip:MovieClip; // specific to this project, we need it to pipe calls back to our parent
		
		private const elementSpacingX:int = 275;
		private const elementSpacingY:int = 135;
		private const elementLeftMargin:int = 40;
		private const elementTopMargin:int = 38;
		
		public function ElementBrowser(xml:XML, parentClip:MovieClip) {
			this.xml = xml;
			this.parentClip = parentClip;
						
			// Spawn the elements
			spawnElementIcons();
			
			// Delegate home button clicks to the parent clip
			homeButton.addEventListener(MouseEvent.CLICK, homeClicked);
		}

		private function homeClicked(e:MouseEvent):void {
			homeButton.removeEventListener(MouseEvent.CLICK, homeClicked);
			parentClip.closeToMenu();
		}
		
		private function spawnElementIcons():void {
			elementIconArray = [];
			elementContainer = new Sprite();
			addChild(elementContainer);
			var xSlot:int = 0;
			var ySlot:int = 0;
			var displaying:int = 0;
			
			for each (var glasses:XML in xml.*) {
				/* Debug code
				trace("this glasses has model: " + glasses.@model + " and browser image url: " + glasses.@browserImage + " comes in a variety of colours:");
				for each (var colour:XML in glasses.*) {
					trace("colour id " + colour.@colourNumber + " thumb url: " + colour.THUMBNAIL + " full url: " + colour.LARGE);
				}
				*/
				
				var elementIcon:ElementIcon = new ElementIcon(glasses[0]);
				elementContainer.addChild(elementIcon);
				elementIconArray.push(elementIcon);
				
				// Calculate placement, 3 per line
				if (xSlot == 3) {
					xSlot = 0;
					ySlot += 1;
				}
				elementIcon.x = elementLeftMargin + xSlot * elementSpacingX;
				elementIcon.y = elementTopMargin + ySlot * elementSpacingY;
				xSlot += 1; // increment count
				
				// Something for listeners
				elementIcon.addEventListener(MouseEvent.CLICK, clickListener);
				elementIcon.buttonMode = true;
				
				// Count of how many glases we are displaying
				displaying++;
			}
			
			// Determine if a scrollbar is required - > 12 items on screen
			if (displaying > 12) {
				
				// Add a mask
				maskSprite = new Sprite();
				maskSprite.graphics.beginFill(0xFF0000);
				maskSprite.graphics.drawRect(20, 20, 830, 535); // fill the screen, minus borders, and minus home button at the bottom
				addChild(maskSprite);
				elementContainer.mask = maskSprite;
				
				// Make a scrollbar graphic
				var scrollbarGripper:MovieClip = new com.jonohennessy.ScrollbarGripper();
				
				// New scrollbar, give it a link to elementContainer, height of the mask, and a desired height of 560, place it at x: 860, y: 30
				scrollBar = new ScrollBar(elementContainer, maskSprite.height, 560, scrollbarGripper);
				scrollBar.x = 855;
				scrollBar.y = 30;
				addChild(scrollBar);
				//scrollBar.initialise();
			}
		}
		
		private function clickListener(e:MouseEvent):void {
			var selectedXML:XML = e.target.parent.getXML();
			//trace(selectedXML);
			
			// Activate it
			popup = new ElementPopup(selectedXML, this);
			addChild(popup);
		}
		
		public function closePopup():void {
			removeChild(popup);
		}
	}
}